SELECT af.[AgentName],
       COUNT(*) AS [TotalFeedbackCount],
       CASE
           WHEN COUNT(*) = 0 THEN 0
           ELSE SUM(CASE WHEN af.[IsHelpful] = 1 THEN 1 ELSE 0 END) * 1.0 / COUNT(*)
END
AS [HelpfulPercentage],
       AVG(CAST(DATEDIFF(SECOND, te.[CreatedAt], af.[SubmittedAt]) AS FLOAT)) AS [AverageTimeToFeedbackSeconds]
FROM [dbo].[AgentFeedbacks] AS af
         INNER JOIN [dbo].[TaskExecutions] AS te ON te.[Id] = af.[TaskId]
GROUP BY af.[AgentName]
ORDER BY af.[AgentName];
