MERGE [dbo].[DecompositionLogs] AS T
    USING (VALUES (@Id, @EpicTaskId, @AgentName, @Timestamp, @SystemPrompt, @UserPrompt, @BreakdownJson)) AS S([Id],
    [EpicTaskId],
    [AgentName],
    [Timestamp],
    [SystemPrompt],
    [UserPrompt],
    [BreakdownJson])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[EpicTaskId] = S.[EpicTaskId],
    T.[AgentName] = S.[AgentName],
    T.[Timestamp] = S.[Timestamp],
    T.[SystemPrompt] = S.[SystemPrompt],
    T.[UserPrompt] = S.[UserPrompt],
    T.[BreakdownJson] = S.[BreakdownJson]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[EpicTaskId],
[AgentName],
[Timestamp],
[SystemPrompt],
[UserPrompt],
[BreakdownJson])
VALUES (S.[Id], S.[EpicTaskId], S.[AgentName], S.[Timestamp], S.[SystemPrompt], S.[UserPrompt], S.[BreakdownJson]);
