SELECT [Id], [WorkspaceId], [ClassificationTag], [PrimarySource], [Sensitivity], [RedactionLevel], [Title], [Summary], [MetadataJson], [SupportingTelemetryIdsJson], [ContributingWorkspacesJson], [Confidence], [SupportCount], [CreatedAtUtc], [LastEvaluatedAtUtc]
FROM [dbo].[KnowledgeAdaptationArtifacts]
WHERE [WorkspaceId] = @WorkspaceId
  AND (@ClassificationTag IS NULL
   OR [ClassificationTag] = @ClassificationTag)
  AND (@PrimarySource IS NULL
   OR [PrimarySource] = @PrimarySource)
  AND (@MinimumConfidence IS NULL
   OR [Confidence] >= @MinimumConfidence)
ORDER BY [Confidence] DESC, [SupportCount] DESC, [CreatedAtUtc] DESC
OFFSET 0 ROWS FETCH NEXT ISNULL(@Limit, 50) ROWS ONLY;
