MERGE [dbo].[KnowledgeAdaptationRollouts] AS Target
    USING
    (SELECT @Id AS [Id],
    @WorkspaceId AS [WorkspaceId],
    @PackId AS [PackId],
    @Status AS [Status],
    @ArtifactIdsJson AS [ArtifactIdsJson],
    @MetricsJson AS [MetricsJson],
    @AlertsJson AS [AlertsJson],
    @ActivatedAtUtc AS [ActivatedAtUtc],
    @UpdatedAtUtc AS [UpdatedAtUtc],
    @RolledBackAtUtc AS [RolledBackAtUtc]) AS Source
    ON Target.[Id] = Source.[Id]
    WHEN MATCHED THEN
UPDATE
    SET [WorkspaceId] = Source.[WorkspaceId],
    [PackId] = Source.[PackId],
    [Status] = Source.[Status],
    [ArtifactIdsJson] = Source.[ArtifactIdsJson],
    [MetricsJson] = Source.[MetricsJson],
    [AlertsJson] = Source.[AlertsJson],
    [ActivatedAtUtc] = Source.[ActivatedAtUtc],
    [UpdatedAtUtc] = Source.[UpdatedAtUtc],
    [RolledBackAtUtc] = Source.[RolledBackAtUtc]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[WorkspaceId],
[PackId],
[Status],
[ArtifactIdsJson],
[MetricsJson],
[AlertsJson],
[ActivatedAtUtc],
[UpdatedAtUtc],
[RolledBackAtUtc])
VALUES (Source.[Id], Source.[WorkspaceId], Source.[PackId], Source.[Status], Source.[ArtifactIdsJson], Source.[MetricsJson], Source.[AlertsJson], Source.[ActivatedAtUtc], Source.[UpdatedAtUtc], Source.[RolledBackAtUtc]);

SELECT *
FROM [dbo].[KnowledgeAdaptationRollouts]
WHERE [WorkspaceId] = @WorkspaceId
  AND [Id] = @Id;
