MERGE [dbo].[PersonaKpiBaselines] AS target
    USING (SELECT @WorkspaceId AS WorkspaceId, @ProjectKey AS ProjectKey, @BaselineType AS BaselineType) AS source
    ON target.[WorkspaceId] = source.[WorkspaceId]
    AND target.[ProjectKey] = source.[ProjectKey]
    AND target.[BaselineType] = source.[BaselineType]
    WHEN MATCHED THEN
UPDATE
    SET [MedianSeconds] = @MedianSeconds,
    [P75Seconds] = @P75Seconds,
    [SampleCount] = @SampleCount,
    [WindowStartUtc] = @WindowStartUtc,
    [WindowEndUtc] = @WindowEndUtc,
    [DataSourceVersion] = @DataSourceVersion,
    [BaselineVersion] = @BaselineVersion,
    [ComputedAtUtc] = @ComputedAtUtc,
    [ComputedByJobId] = @ComputedByJobId
    WHEN NOT MATCHED THEN
INSERT
(
[WorkspaceId],
[ProjectKey],
[BaselineType],
[MedianSeconds],
[P75Seconds],
[SampleCount],
[WindowStartUtc],
[WindowEndUtc],
[DataSourceVersion],
[BaselineVersion],
[ComputedAtUtc],
[ComputedByJobId])
VALUES (@WorkspaceId, @ProjectKey, @BaselineType, @MedianSeconds, @P75Seconds, @SampleCount, @WindowStartUtc, @WindowEndUtc, @DataSourceVersion, @BaselineVersion, @ComputedAtUtc, @ComputedByJobId);
