MERGE [dbo].[ProjectItems] AS T
    USING (VALUES (@Id, @WorkspaceId, @ProjectKey, @Title, @Description, @Type, @Status, @State, @Estimate, @Priority, @AssignedTo, @CustomFields, @Labels, @AcceptanceCriteria, @ParentId, @Decision)) AS S([Id],
    [WorkspaceId],
    [ProjectKey],
    [Title],
    [Description],
    [Type],
    [Status],
    [State],
    [Estimate],
    [Priority],
    [AssignedTo],
    [CustomFields],
    [Labels],
    [AcceptanceCriteria],
    [ParentId],
    [Decision])
    ON T.[Id] = S.[Id]
    AND T.[WorkspaceId] = S.[WorkspaceId]
    WHEN MATCHED THEN
UPDATE
    SET T.[ProjectKey] = S.[ProjectKey],
    T.[Title] = S.[Title],
    T.[Description] = S.[Description],
    T.[Type] = S.[Type],
    T.[Status] = S.[Status],
    T.[State] = S.[State],
    T.[Estimate] = S.[Estimate],
    T.[Priority] = S.[Priority],
    T.[AssignedTo] = S.[AssignedTo],
    T.[CustomFields]= S.[CustomFields],
    T.[Labels] = S.[Labels],
    T.[AcceptanceCriteria] = S.[AcceptanceCriteria],
    T.[ParentId] = S.[ParentId],
    T.[Decision] = S.[Decision]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[WorkspaceId],
[ProjectKey],
[Title],
[Description],
[Type],
[Status],
[State],
[Estimate],
[Priority],
[AssignedTo],
[CustomFields],
[Labels],
[AcceptanceCriteria],
[ParentId],
[Decision])
VALUES (S.[Id], S.[WorkspaceId], S.[ProjectKey], S.[Title], S.[Description], S.[Type], S.[Status], S.[State], S.[Estimate], S.[Priority], S.[AssignedTo], S.[CustomFields], S.[Labels], S.[AcceptanceCriteria], S.[ParentId], S.[Decision]);
