MERGE [dbo].[PromptLogs] AS T
    USING (VALUES (@Id, @Timestamp, @SystemPrompt, @UserPrompt, @Response, @Metadata)) AS S([Id], [Timestamp],
    [SystemPrompt], [UserPrompt],
    [Response], [Metadata])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[Timestamp] = S.[Timestamp],
    T.[SystemPrompt] = S.[SystemPrompt],
    T.[UserPrompt] = S.[UserPrompt],
    T.[Response] = S.[Response],
    T.[Metadata] = S.[Metadata]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[Timestamp],
[SystemPrompt],
[UserPrompt],
[Response],
[Metadata])
VALUES (S.[Id], S.[Timestamp], S.[SystemPrompt], S.[UserPrompt], S.[Response], S.[Metadata]);
