SELECT wr.[Id],
       wr.[WorkspaceId],
       wr.[Email],
       wr.[DisplayName],
       wr.[IsActive],
       wr.[TimeZone],
       wr.[AvailabilityStart],
       wr.[AvailabilityEnd],
       wr.[VacationStart],
       wr.[VacationEnd],
       wr.[IsOutOfOffice],
       ra.[Id] AS AvailabilitySplit,
       ra.*
FROM [dbo].[ReviewerGroupMemberships] AS m
    INNER JOIN [dbo].[ReviewerGroups] AS g
ON g.[Id] = m.[ReviewerGroupId]
    INNER JOIN [dbo].[WorkspaceReviewers] AS wr ON wr.[Id] = m.[WorkspaceReviewerId]
    LEFT JOIN [dbo].[ReviewerAvailabilities] AS ra ON ra.[ReviewerId] = wr.[Id]
WHERE g.[WorkspaceId] = @WorkspaceId
  AND g.[TaskType] = @TaskType
  AND wr.[IsActive] = 1
ORDER BY wr.[DisplayName]
