SELECT sf.[StrategyId] AS [StrategyId],
       COUNT(*)                                                             AS [TotalTasks],
       AVG(CAST(CASE WHEN sf.[Success] = 1 THEN 1.0 ELSE 0.0 END AS FLOAT)) AS [SuccessRate],
       AVG(CAST(sf.[RetryCount] AS FLOAT))                                  AS [AverageRetries],
       AVG(CAST(sf.[FeedbackScore] AS FLOAT))                               AS [AverageFeedbackScore],
       AVG(CAST(COALESCE(sf.[DiffSize], 0) AS FLOAT))                       AS [AverageDiffSize],
       AVG(CAST(sf.[DurationSeconds] AS FLOAT))                             AS [AverageDurationSeconds]
FROM [dbo].[StrategyFitness] AS sf
WHERE sf.[StrategyId] = @StrategyId
  AND (@Since IS NULL
   OR sf.[RecordedAt] >= @Since)
GROUP BY sf.[StrategyId];
