SELECT te.[Id],
       te.[ExecutionMode],
       te.[WorkKind],
       te.[ExecutionType],
       te.[AssignedAgent],
       te.[QueuedAt],
       te.[StartedAt],
       te.[FinishedAt],
       te.[Status],
       te.[InputDataJson],
       te.[OutputDataJson],
       te.[OutputDataRef],
       te.[ErrorMessage],
       te.[CorrelationId],
       te.[ReplayedFromTaskId],
       te.[WorkspaceId],
       te.[AssignmentType],
       te.[ConfidenceScore],
       te.[RetryCount],
       te.[LastRetryAt],
       te.[MaxRetryAttempts],
       te.[RetryReason],
       te.[Priority],
       te.[RetryOfTaskId],
       te.[SuggestionLogId],
       te.[CreatedAt],
       te.[SuggestedPatchJson],
       te.[AiReviewEvidenceManifestJson],
       te.[AiReviewStatus],
       te.[CreatedVia],
       te.[Language], te.[Domain], te.[RepositoryUrl], te.[Branch], te.[FilePath], te.[Prompt], te.[OutputFormat], te.[TriggerSource], te.[ExternalId], te.[ExternalSystem], te.[RowVersion]
FROM [dbo].[TaskExecutions] te
WHERE te.[Status] = @Status
  AND COALESCE (
    (SELECT CAST (MAX (st.[Timestamp]) AS datetime2(7))
    FROM [dbo].[StatusTransitions] st
    WHERE st.[TaskExecutionId] = te.[Id])
    , te.[QueuedAt]
    ) <= @Threshold
ORDER BY te.[QueuedAt];
