MERGE [dbo].[WorkspaceInvites] AS T
    USING (VALUES (@Id, @WorkspaceId, @Email, @RoleIds, @Token, @CreatedAt, @Accepted))
        AS S([Id], [WorkspaceId], [Email], [RoleIds], [Token], [CreatedAt], [Accepted])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[WorkspaceId] = S.[WorkspaceId],
    T.[Email] = S.[Email],
    T.[RoleIds] = S.[RoleIds],
    T.[Token] = S.[Token],
    T.[CreatedAt] = S.[CreatedAt],
    T.[Accepted] = S.[Accepted]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[WorkspaceId],
[Email],
[RoleIds],
[Token],
[CreatedAt],
[Accepted])
VALUES (S.[Id], S.[WorkspaceId], S.[Email], S.[RoleIds], S.[Token], S.[CreatedAt], S.[Accepted]);
