MERGE [dbo].[WorkspaceSettings] AS T
    USING (VALUES (@Id, @WorkspaceId, @Key, @Value, @IsSecret)) AS S([Id], [WorkspaceId], [Key], [Value], [IsSecret])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[WorkspaceId] = S.[WorkspaceId],
        T.[Key] = S.[Key],
        T.[Value] = S.[Value],
        T.[IsSecret] = S.[IsSecret]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[WorkspaceId],
[Key],
[Value],
[IsSecret])
VALUES (S.[Id], S.[WorkspaceId], S.[Key], S.[Value], S.[IsSecret]);
