MERGE [dbo].[ProjectItemComments] AS T
    USING (VALUES (@Id, @WorkItemId, @Comment, @CreatedAt)) AS S([Id], [WorkItemId], [Comment], [CreatedAt])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[WorkItemId] = S.[WorkItemId],
    T.[Comment] = S.[Comment],
    T.[CreatedAt] = S.[CreatedAt]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[WorkItemId],
[Comment],
[CreatedAt])
VALUES (S.[Id], S.[WorkItemId], S.[Comment], S.[CreatedAt]);
