MERGE [dbo].[SuggestionLogs] AS T
    USING (VALUES (@Id, @TaskExecutionId, @AgentName, @SuggestionJson, @Timestamp, @Decision, @DecisionAt,
    @FollowUpTaskId)) AS S([Id], [TaskExecutionId], [AgentName], [SuggestionJson], [Timestamp], [Decision],
    [DecisionAt], [FollowUpTaskId])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[TaskExecutionId] = S.[TaskExecutionId],
    T.[AgentName] = S.[AgentName],
    T.[SuggestionJson] = S.[SuggestionJson],
    T.[Timestamp] = S.[Timestamp],
    T.[Decision] = S.[Decision],
    T.[DecisionAt] = S.[DecisionAt],
    T.[FollowUpTaskId] = S.[FollowUpTaskId]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[TaskExecutionId],
[AgentName],
[SuggestionJson],
[Timestamp],
[Decision],
[DecisionAt],
[FollowUpTaskId])
VALUES (S.[Id], S.[TaskExecutionId], S.[AgentName], S.[SuggestionJson], S.[Timestamp], S.[Decision], S.[DecisionAt], S.[FollowUpTaskId]);
