MERGE [dbo].[WorkspaceIntegrations] AS T
    USING (VALUES (@Id, @WorkspaceId, @SystemType, @Endpoint, @Token, @AuthType, @BotUserName, @ProjectKey, @TypeField,
    @StatusField, @EstimateField, @PriorityField, @IsPrimary, @CreatedAt, @ConnectedAtUtc, @ConnectionState,
    @LastTestError, @LastTestedAtUtc, @WebhookId, @WebhookSecret, @CreateIntegrationIssuesOnDecomposition,
    @AutoAssignIntegrationIssuesOnDecomposition)) AS S([Id], [WorkspaceId], [SystemType],
    [Endpoint], [Token], [AuthType],
    [BotUserName], [ProjectKey],
    [TypeField], [StatusField],
    [EstimateField], [PriorityField],
    [IsPrimary], [CreatedAt],
    [ConnectedAtUtc], [ConnectionState],
    [LastTestError], [LastTestedAtUtc],
    [WebhookId], [WebhookSecret], [CreateIntegrationIssuesOnDecomposition], [AutoAssignIntegrationIssuesOnDecomposition])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[WorkspaceId] = S.[WorkspaceId],
    T.[SystemType] = S.[SystemType],
    T.[Endpoint] = S.[Endpoint],
    T.[Token] = S.[Token],
    T.[AuthType] = S.[AuthType],
    T.[BotUserName] = S.[BotUserName],
    T.[ProjectKey] = S.[ProjectKey],
    T.[TypeField] = S.[TypeField],
    T.[StatusField] = S.[StatusField],
    T.[EstimateField] = S.[EstimateField],
    T.[PriorityField] = S.[PriorityField],
    T.[IsPrimary] = S.[IsPrimary],
    T.[CreatedAt] = S.[CreatedAt],
    T.[ConnectedAtUtc] = S.[ConnectedAtUtc],
    T.[ConnectionState] = S.[ConnectionState],
    T.[LastTestError] = S.[LastTestError],
    T.[LastTestedAtUtc] = S.[LastTestedAtUtc],
    T.[WebhookId] = S.[WebhookId],
    T.[WebhookSecret] = S.[WebhookSecret],
    T.[CreateIntegrationIssuesOnDecomposition] = S.[CreateIntegrationIssuesOnDecomposition],
    T.[AutoAssignIntegrationIssuesOnDecomposition] = S.[AutoAssignIntegrationIssuesOnDecomposition]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[WorkspaceId],
[SystemType],
[Endpoint],
[Token],
[AuthType],
[BotUserName],
[ProjectKey],
[TypeField],
[StatusField],
[EstimateField],
[PriorityField],
[IsPrimary],
[CreatedAt],
[ConnectedAtUtc],
[ConnectionState],
[LastTestError],
[LastTestedAtUtc],
[WebhookId],
[WebhookSecret],
[CreateIntegrationIssuesOnDecomposition],
[AutoAssignIntegrationIssuesOnDecomposition])
VALUES (S.[Id], S.[WorkspaceId], S.[SystemType], S.[Endpoint], S.[Token], S.[AuthType], S.[BotUserName], S.[ProjectKey], S.[TypeField], S.[StatusField], S.[EstimateField], S.[PriorityField], S.[IsPrimary], S.[CreatedAt], S.[ConnectedAtUtc], S.[ConnectionState], S.[LastTestError], S.[LastTestedAtUtc], S.[WebhookId], S.[WebhookSecret], S.[CreateIntegrationIssuesOnDecomposition], S.[AutoAssignIntegrationIssuesOnDecomposition]);
