SELECT af.[Id],
       af.[TaskId],
       af.[AgentName],
       af.[IsHelpful],
       af.[Comment],
       af.[SubmittedAt],
       af.[Source],
       af.[SuggestedAgent],
       af.[Category],
       te.[Id] AS [TaskExecutionId],
       te.[ExecutionType],
       te.[WorkspaceId],
       te.[CreatedAt]
FROM [dbo].[AgentFeedbacks] AS af
    INNER JOIN [dbo].[TaskExecutions] AS te
ON te.[Id] = af.[TaskId]
WHERE af.[SubmittedAt] >= @From
  AND af.[SubmittedAt] <= @To
ORDER BY af.[SubmittedAt] DESC, af.[Id];
