MERGE [dbo].[AgentOutcomeLearningRolloutToggles] AS Target
    USING (VALUES (@Id,
    @ProposalId,
    @WorkspaceId,
    @AgentId,
    @DecisionKey,
    @Action,
    @Status,
    @ActivatedAt,
    @DeactivatedAt,
    @RollbackReason,
    @MetadataJson))
    AS Source (
    Id,
    ProposalId,
    WorkspaceId,
    AgentId,
    DecisionKey,
    Action,
    Status,
    ActivatedAt,
    DeactivatedAt,
    RollbackReason,
    MetadataJson)
    ON Target.[Id] = Source.Id
    WHEN MATCHED THEN
UPDATE
    SET [ProposalId] = Source.ProposalId,
    [ActivatedAt] = Source.ActivatedAt,
    [DeactivatedAt] = Source.DeactivatedAt,
    [RollbackReason] = Source.RollbackReason,
    [MetadataJson] = Source.MetadataJson,
    [UpdatedAt] = SYSUTCDATETIME()
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[ProposalId],
[WorkspaceId],
[AgentId],
[DecisionKey],
[Action],
[Status],
[ActivatedAt],
[DeactivatedAt],
[RollbackReason],
[MetadataJson],
[CreatedAt],
[UpdatedAt])
VALUES (Source.Id, Source.ProposalId, Source.WorkspaceId, Source.AgentId, Source.DecisionKey, Source.Action, Source.Status, Source.ActivatedAt, Source.DeactivatedAt, Source.RollbackReason, Source.MetadataJson, SYSUTCDATETIME(), SYSUTCDATETIME())
    OUTPUT inserted.*;
