MERGE [dbo].[CapabilityHints] AS T
    USING (VALUES (@Id, @WorkspaceId, @OriginalAgent, @ReroutedAgent, @TaskType, @WorkKind, @ReviewerEmail, @ReviewerComment,
    @CreatedAt)) AS S([Id], [WorkspaceId], [OriginalAgent], [ReroutedAgent], [TaskType], [WorkKind], [ReviewerEmail],
    [ReviewerComment], [CreatedAt])
    ON T.[Id] = S.[Id] AND T.[WorkspaceId] = S.[WorkspaceId]
    WHEN MATCHED THEN
UPDATE
    SET T.[OriginalAgent] = S.[OriginalAgent],
    T.[ReroutedAgent] = S.[ReroutedAgent],
    T.[TaskType] = S.[TaskType],
    T.[WorkKind] = S.[WorkKind],
    T.[ReviewerEmail] = S.[ReviewerEmail],
    T.[ReviewerComment] = S.[ReviewerComment],
    T.[CreatedAt] = S.[CreatedAt]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[WorkspaceId],
[OriginalAgent],
[ReroutedAgent],
[TaskType],
[WorkKind],
[ReviewerEmail],
[ReviewerComment],
[CreatedAt])
VALUES (S.[Id], S.[WorkspaceId], S.[OriginalAgent], S.[ReroutedAgent], S.[TaskType], S.[WorkKind], S.[ReviewerEmail], S.[ReviewerComment], S.[CreatedAt]);
