SELECT
    [Id], [RunId], [TenantId], [WorkspaceId], [WorkspaceName], [Plan], [Status], [Rule], [DisabledAt]
FROM [dbo].[DelinquentWorkspaceEnforcementEvents]
WHERE (@TenantId IS NULL
   OR [TenantId] = @TenantId)
  AND (@From IS NULL
   OR [DisabledAt] >= @From)
  AND (@To IS NULL
   OR [DisabledAt] <= @To)
  AND (@Plan IS NULL
   OR [Plan] = @Plan)
  AND (@Status IS NULL
   OR [Status] = @Status)
  AND (@Rule IS NULL
   OR [Rule] = @Rule)
  AND (@WorkspaceQuery IS NULL
   OR [WorkspaceName] LIKE '%' + @WorkspaceQuery + '%'
   OR CONVERT(NVARCHAR(36), [WorkspaceId]) LIKE '%' + @WorkspaceQuery + '%')
ORDER BY [DisabledAt] DESC
OFFSET @Offset ROWS FETCH NEXT @PageSize ROWS ONLY;

SELECT COUNT(1)
FROM [dbo].[DelinquentWorkspaceEnforcementEvents]
WHERE (@TenantId IS NULL
   OR [TenantId] = @TenantId)
  AND (@From IS NULL
   OR [DisabledAt] >= @From)
  AND (@To IS NULL
   OR [DisabledAt] <= @To)
  AND (@Plan IS NULL
   OR [Plan] = @Plan)
  AND (@Status IS NULL
   OR [Status] = @Status)
  AND (@Rule IS NULL
   OR [Rule] = @Rule)
  AND (@WorkspaceQuery IS NULL
   OR [WorkspaceName] LIKE '%' + @WorkspaceQuery + '%'
   OR CONVERT(NVARCHAR(36), [WorkspaceId]) LIKE '%' + @WorkspaceQuery + '%');
