SELECT
    [Id], [RunId], [TenantId], [WorkspaceId], [WorkspaceName], [Plan], [Status], [ReactivatedAt]
FROM [dbo].[DelinquentWorkspaceReactivationEvents]
WHERE (@TenantId IS NULL
   OR [TenantId] = @TenantId)
  AND (@From IS NULL
   OR [ReactivatedAt] >= @From)
  AND (@To IS NULL
   OR [ReactivatedAt] <= @To)
  AND (@Plan IS NULL
   OR [Plan] = @Plan)
  AND (@Status IS NULL
   OR [Status] = @Status)
  AND (@WorkspaceQuery IS NULL
   OR [WorkspaceName] LIKE '%' + @WorkspaceQuery + '%'
   OR CONVERT(NVARCHAR(36), [WorkspaceId]) LIKE '%' + @WorkspaceQuery + '%')
ORDER BY [ReactivatedAt] DESC
OFFSET @Offset ROWS FETCH NEXT @PageSize ROWS ONLY;

SELECT COUNT(1)
FROM [dbo].[DelinquentWorkspaceReactivationEvents]
WHERE (@TenantId IS NULL
   OR [TenantId] = @TenantId)
  AND (@From IS NULL
   OR [ReactivatedAt] >= @From)
  AND (@To IS NULL
   OR [ReactivatedAt] <= @To)
  AND (@Plan IS NULL
   OR [Plan] = @Plan)
  AND (@Status IS NULL
   OR [Status] = @Status)
  AND (@WorkspaceQuery IS NULL
   OR [WorkspaceName] LIKE '%' + @WorkspaceQuery + '%'
   OR CONVERT(NVARCHAR(36), [WorkspaceId]) LIKE '%' + @WorkspaceQuery + '%');
