MERGE [dbo].[ReviewAuditEvents] AS T
    USING (VALUES (@Id, @TaskReviewId, @ReviewerEmail, @ReviewerDisplayName, @Decision, @Timestamp, @Feedback, @Notes,
    @StrategyId, @StrategyRating, @StrategyComment)) AS S([Id], [TaskReviewId], [ReviewerEmail],
    [ReviewerDisplayName], [Decision], [Timestamp],
    [Feedback], [Notes], [StrategyId],
    [StrategyRating], [StrategyComment])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[TaskReviewId] = S.[TaskReviewId],
    T.[ReviewerEmail] = S.[ReviewerEmail],
    T.[ReviewerDisplayName] = S.[ReviewerDisplayName],
    T.[Decision] = S.[Decision],
    T.[Timestamp] = S.[Timestamp],
    T.[Feedback] = S.[Feedback],
    T.[Notes] = S.[Notes],
    T.[StrategyId] = S.[StrategyId],
    T.[StrategyRating] = S.[StrategyRating],
    T.[StrategyComment] = S.[StrategyComment]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[TaskReviewId],
[ReviewerEmail],
[ReviewerDisplayName],
[Decision],
[Timestamp],
[Feedback],
[Notes],
[StrategyId],
[StrategyRating],
[StrategyComment])
VALUES (S.[Id], S.[TaskReviewId], S.[ReviewerEmail], S.[ReviewerDisplayName], S.[Decision], S.[Timestamp], S.[Feedback], S.[Notes], S.[StrategyId], S.[StrategyRating], S.[StrategyComment]);
