MERGE [dbo].[ReviewerGroups] AS T
    USING (VALUES (@Id, @WorkspaceId, @Name, @TaskType, @IncludePool)) AS S([Id], [WorkspaceId], [Name], [TaskType], [IncludePool])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[WorkspaceId] = S.[WorkspaceId],
    T.[Name] = S.[Name],
    T.[TaskType] = S.[TaskType],
    T.[IncludePool] = S.[IncludePool]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[WorkspaceId],
[Name],
[TaskType],
[IncludePool])
VALUES (S.[Id], S.[WorkspaceId], S.[Name], S.[TaskType], S.[IncludePool]);
