MERGE [dbo].[TaskExecutionMetadata] AS T
    USING (VALUES (@Id, @TaskExecutionId, @Key, @Value)) AS S([Id], [TaskExecutionId], [Key], [Value])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[TaskExecutionId] = S.[TaskExecutionId],
    T.[Key] = S.[Key],
    T.[Value] = S.[Value]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[TaskExecutionId],
[Key],
[Value])
VALUES (S.[Id], S.[TaskExecutionId], S.[Key], S.[Value]);
