MERGE [dbo].[TaskExecutions] AS T
    USING (VALUES (@Id, @ExecutionMode, @WorkKind, @ExecutionType, @AssignedAgent, @QueuedAt, @StartedAt, @FinishedAt,
    @Status, @InputDataJson, @OutputDataJson, @OutputDataRef, @ErrorMessage, @CorrelationId,
    @ReplayedFromTaskId, @WorkspaceId, @AssignmentType, @ConfidenceScore, @RetryCount, @LastRetryAt,
    @MaxRetryAttempts, @RetryReason, @Priority, @RetryOfTaskId, @SuggestionLogId, @CreatedAt,
    @SuggestedPatchJson, @AiReviewEvidenceManifestJson, @AiReviewStatus, @CreatedVia, @Language, @Domain,
    @RepositoryUrl, @Branch, @FilePath, @Prompt, @OutputFormat, @TriggerSource, @ExternalId,
    @ExternalSystem)) AS S([Id], [ExecutionMode], [WorkKind], [ExecutionType], [AssignedAgent], [QueuedAt],
    [StartedAt], [FinishedAt], [Status], [InputDataJson], [OutputDataJson],
    [OutputDataRef], [ErrorMessage], [CorrelationId], [ReplayedFromTaskId],
    [WorkspaceId], [AssignmentType], [ConfidenceScore], [RetryCount], [LastRetryAt],
    [MaxRetryAttempts], [RetryReason], [Priority], [RetryOfTaskId], [SuggestionLogId],
    [CreatedAt], [SuggestedPatchJson], [AiReviewEvidenceManifestJson],
    [AiReviewStatus], [CreatedVia], [Language], [Domain], [RepositoryUrl], [Branch],
    [FilePath], [Prompt], [OutputFormat], [TriggerSource], [ExternalId],
    [ExternalSystem])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[ExecutionMode] = S.[ExecutionMode],
    T.[WorkKind] = S.[WorkKind],
    T.[ExecutionType] = S.[ExecutionType],
    T.[AssignedAgent] = S.[AssignedAgent],
    T.[QueuedAt] = S.[QueuedAt],
    T.[StartedAt] = S.[StartedAt],
    T.[FinishedAt] = S.[FinishedAt],
    T.[Status] = S.[Status],
    T.[InputDataJson] = S.[InputDataJson],
    T.[OutputDataJson] = S.[OutputDataJson],
    T.[OutputDataRef] = S.[OutputDataRef],
    T.[ErrorMessage] = S.[ErrorMessage],
    T.[CorrelationId] = S.[CorrelationId],
    T.[ReplayedFromTaskId] = S.[ReplayedFromTaskId],
    T.[WorkspaceId] = S.[WorkspaceId],
    T.[AssignmentType] = S.[AssignmentType],
    T.[ConfidenceScore] = S.[ConfidenceScore],
    T.[RetryCount] = S.[RetryCount],
    T.[LastRetryAt] = S.[LastRetryAt],
    T.[MaxRetryAttempts] = S.[MaxRetryAttempts],
    T.[RetryReason] = S.[RetryReason],
    T.[Priority] = S.[Priority],
    T.[RetryOfTaskId] = S.[RetryOfTaskId],
    T.[SuggestionLogId] = S.[SuggestionLogId],
    T.[CreatedAt] = S.[CreatedAt],
    T.[SuggestedPatchJson] = S.[SuggestedPatchJson],
    T.[AiReviewEvidenceManifestJson] = S.[AiReviewEvidenceManifestJson],
    T.[AiReviewStatus] = S.[AiReviewStatus],
    T.[CreatedVia] = S.[CreatedVia],
    T.[Language] = S.[Language],
    T.[Domain] = S.[Domain],
    T.[RepositoryUrl] = S.[RepositoryUrl],
    T.[Branch] = S.[Branch],
    T.[FilePath] = S.[FilePath],
    T.[Prompt] = S.[Prompt],
    T.[OutputFormat] = S.[OutputFormat],
    T.[TriggerSource] = S.[TriggerSource],
    T.[ExternalId] = S.[ExternalId],
    T.[ExternalSystem] = S.[ExternalSystem]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[ExecutionMode],
[WorkKind],
[ExecutionType],
[AssignedAgent],
[QueuedAt],
[StartedAt],
[FinishedAt],
[Status],
[InputDataJson],
[OutputDataJson],
[OutputDataRef],
[ErrorMessage],
[CorrelationId],
[ReplayedFromTaskId],
[WorkspaceId],
[AssignmentType],
[ConfidenceScore],
[RetryCount],
[LastRetryAt],
[MaxRetryAttempts],
[RetryReason],
[Priority],
[RetryOfTaskId],
[SuggestionLogId],
[CreatedAt],
[SuggestedPatchJson],
[AiReviewEvidenceManifestJson],
[AiReviewStatus],
[CreatedVia],
[Language],
[Domain],
[RepositoryUrl],
[Branch],
[FilePath],
[Prompt],
[OutputFormat],
[TriggerSource],
[ExternalId],
[ExternalSystem])
VALUES (S.[Id], S.[ExecutionMode], S.[WorkKind], S.[ExecutionType], S.[AssignedAgent], S.[QueuedAt], S.[StartedAt], S.[FinishedAt], S.[Status], S.[InputDataJson], S.[OutputDataJson], S.[OutputDataRef], S.[ErrorMessage], S.[CorrelationId], S.[ReplayedFromTaskId], S.[WorkspaceId], S.[AssignmentType], S.[ConfidenceScore], S.[RetryCount], S.[LastRetryAt], S.[MaxRetryAttempts], S.[RetryReason], S.[Priority], S.[RetryOfTaskId], S.[SuggestionLogId], S.[CreatedAt], S.[SuggestedPatchJson], S.[AiReviewEvidenceManifestJson], S.[AiReviewStatus], S.[CreatedVia], S.[Language], S.[Domain], S.[RepositoryUrl], S.[Branch], S.[FilePath], S.[Prompt], S.[OutputFormat], S.[TriggerSource], S.[ExternalId], S.[ExternalSystem]);
