MERGE [dbo].[TaskReviews] AS T
    USING (VALUES (@Id, @TaskExecutionId, @ReviewerEmail, @ReviewerId, @Decision, @Feedback, @RequestedAt, @RespondedAt,
    @RespondedBy, @ExpectedSlaDuration, @SlaViolatedAt, @IsLate, @IsOverdue, @ReviewerDisplayName,
    @RespondedByDisplayName, @IsHelpful, @Flags, @SuggestedPrompt, @StrategyId, @StrategyRating,
    @StrategyComment)) AS S([Id], [TaskExecutionId], [ReviewerEmail], [ReviewerId], [Decision], [Feedback],
    [RequestedAt], [RespondedAt], [RespondedBy], [ExpectedSlaDuration],
    [SlaViolatedAt], [IsLate], [IsOverdue], [ReviewerDisplayName],
    [RespondedByDisplayName], [IsHelpful], [Flags], [SuggestedPrompt], [StrategyId],
    [StrategyRating], [StrategyComment])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[TaskExecutionId] = S.[TaskExecutionId],
    T.[ReviewerEmail] = S.[ReviewerEmail],
    T.[ReviewerId] = S.[ReviewerId],
    T.[Decision] = S.[Decision],
    T.[Feedback] = S.[Feedback],
    T.[RequestedAt] = S.[RequestedAt],
    T.[RespondedAt] = S.[RespondedAt],
    T.[RespondedBy] = S.[RespondedBy],
    T.[ExpectedSlaDuration] = S.[ExpectedSlaDuration],
    T.[SlaViolatedAt] = S.[SlaViolatedAt],
    T.[IsLate] = S.[IsLate],
    T.[IsOverdue] = S.[IsOverdue],
    T.[ReviewerDisplayName] = S.[ReviewerDisplayName],
    T.[RespondedByDisplayName] = S.[RespondedByDisplayName],
    T.[IsHelpful] = S.[IsHelpful],
    T.[Flags] = S.[Flags],
    T.[SuggestedPrompt] = S.[SuggestedPrompt],
    T.[StrategyId] = S.[StrategyId],
    T.[StrategyRating] = S.[StrategyRating],
    T.[StrategyComment] = S.[StrategyComment]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[TaskExecutionId],
[ReviewerEmail],
[ReviewerId],
[Decision],
[Feedback],
[RequestedAt],
[RespondedAt],
[RespondedBy],
[ExpectedSlaDuration],
[SlaViolatedAt],
[IsLate],
[IsOverdue],
[ReviewerDisplayName],
[RespondedByDisplayName],
[IsHelpful],
[Flags],
[SuggestedPrompt],
[StrategyId],
[StrategyRating],
[StrategyComment])
VALUES (S.[Id], S.[TaskExecutionId], S.[ReviewerEmail], S.[ReviewerId], S.[Decision], S.[Feedback], S.[RequestedAt], S.[RespondedAt], S.[RespondedBy], S.[ExpectedSlaDuration], S.[SlaViolatedAt], S.[IsLate], S.[IsOverdue], S.[ReviewerDisplayName], S.[RespondedByDisplayName], S.[IsHelpful], S.[Flags], S.[SuggestedPrompt], S.[StrategyId], S.[StrategyRating], S.[StrategyComment]);
