MERGE [dbo].[TenantSettings] AS T
    USING (VALUES (@Id, @TenantId, @Key, @Value)) AS S([Id], [TenantId], [Key], [Value])
    ON T.[TenantId] = S.[TenantId] AND T.[Key] = S.[Key]
    WHEN MATCHED THEN
UPDATE
    SET T.[Value] = S.[Value]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[TenantId],
[Key],
[Value])
VALUES (S.[Id], S.[TenantId], S.[Key], S.[Value]);
