MERGE [dbo].[TenantUserRoles] AS T
    USING (VALUES (@TenantId, @UserId, @Role)) AS S([TenantId], [UserId], [Role])
    ON T.[TenantId] = S.[TenantId] AND T.[UserId] = S.[UserId]
    WHEN MATCHED THEN
UPDATE
    SET T.[Role] = S.[Role]
    WHEN NOT MATCHED THEN
INSERT
(
[TenantId],
[UserId],
[Role])
VALUES (S.[TenantId], S.[UserId], S.[Role]);
