MERGE [dbo].[WorkflowAuditEvents] AS T
    USING (VALUES (@Id, @Step, @Details, @Timestamp)) AS S([Id], [Step], [Details], [Timestamp])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[Step] = S.[Step],
    T.[Details] = S.[Details],
    T.[Timestamp] = S.[Timestamp]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[Step],
[Details],
[Timestamp])
VALUES (S.[Id], S.[Step], S.[Details], S.[Timestamp]);
