MERGE [dbo].[WorkspaceMembers] AS T
    USING (VALUES (@Id, @WorkspaceId, @Email, @FirstName, @LastName, @UserId, @Role, @Status, @Phone, @WelcomeEmailSendingUtc, @WelcomeEmailSentUtc)) AS S([Id],
    [WorkspaceId],
    [Email],
    [FirstName],
    [LastName],
    [UserId],
    [Role],
    [Status],
    [Phone],
    [WelcomeEmailSendingUtc],
    [WelcomeEmailSentUtc])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[WorkspaceId] = S.[WorkspaceId],
    T.[Email] = S.[Email],
    T.[FirstName] = S.[FirstName],
    T.[LastName] = S.[LastName],
    T.[UserId] = S.[UserId],
    T.[Role] = S.[Role],
    T.[Status] = S.[Status],
    T.[Phone] = S.[Phone],
    T.[WelcomeEmailSendingUtc] = S.[WelcomeEmailSendingUtc],
    T.[WelcomeEmailSentUtc] = S.[WelcomeEmailSentUtc]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[WorkspaceId],
[Email],
[FirstName],
[LastName],
[UserId],
[Role],
[Status],
[Phone],
[WelcomeEmailSendingUtc],
[WelcomeEmailSentUtc])
VALUES (S.[Id], S.[WorkspaceId], S.[Email], S.[FirstName], S.[LastName], S.[UserId], S.[Role], S.[Status], S.[Phone], S.[WelcomeEmailSendingUtc], S.[WelcomeEmailSentUtc]);