MERGE [dbo].[WorkspaceReviewers] AS T
    USING (VALUES (@Id, @WorkspaceId, @Email, @DisplayName, @IsActive, @TimeZone, @AvailabilityStart, @AvailabilityEnd,
    @VacationStart, @VacationEnd, @IsOutOfOffice)) AS S([Id], [WorkspaceId], [Email], [DisplayName],
    [IsActive], [TimeZone], [AvailabilityStart],
    [AvailabilityEnd], [VacationStart], [VacationEnd],
    [IsOutOfOffice])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[WorkspaceId] = S.[WorkspaceId],
    T.[Email] = S.[Email],
    T.[DisplayName] = S.[DisplayName],
    T.[IsActive] = S.[IsActive],
    T.[TimeZone] = S.[TimeZone],
    T.[AvailabilityStart] = S.[AvailabilityStart],
    T.[AvailabilityEnd] = S.[AvailabilityEnd],
    T.[VacationStart] = S.[VacationStart],
    T.[VacationEnd] = S.[VacationEnd],
    T.[IsOutOfOffice] = S.[IsOutOfOffice]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[WorkspaceId],
[Email],
[DisplayName],
[IsActive],
[TimeZone],
[AvailabilityStart],
[AvailabilityEnd],
[VacationStart],
[VacationEnd],
[IsOutOfOffice])
VALUES (S.[Id], S.[WorkspaceId], S.[Email], S.[DisplayName], S.[IsActive], S.[TimeZone], S.[AvailabilityStart], S.[AvailabilityEnd], S.[VacationStart], S.[VacationEnd], S.[IsOutOfOffice]);
