MERGE [dbo].[AgentCapabilitySuggestions] AS T
    USING (VALUES (@Id, @WorkspaceId, @AgentName, @ExecutionType, @Action, @Reason, @CreatedAt)) AS S([Id], [WorkspaceId], [AgentName], [ExecutionType], [Action], [Reason], [CreatedAt])
    ON T.[Id] = S.[Id] AND T.[WorkspaceId] = S.[WorkspaceId]
    WHEN MATCHED THEN
UPDATE
    SET T.[AgentName] = S.[AgentName],
    T.[ExecutionType] = S.[ExecutionType],
    T.[Action] = S.[Action],
    T.[Reason] = S.[Reason],
    T.[CreatedAt] = S.[CreatedAt]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[WorkspaceId],
[AgentName],
[ExecutionType],
[Action],
[Reason],
[CreatedAt])
VALUES (S.[Id], S.[WorkspaceId], S.[AgentName], S.[ExecutionType], S.[Action], S.[Reason], S.[CreatedAt]);
