SELECT COUNT(*) AS [Total],
       COALESCE(SUM(CASE WHEN [Status] = 1 THEN 1 ELSE 0 END), 0) AS [Active],
       COALESCE(SUM(CASE WHEN [Status] = 3 THEN 1 ELSE 0 END), 0) AS [Completed],
       COALESCE(SUM(CASE WHEN [Status] = 2 THEN 1 ELSE 0 END), 0) AS [RolledBack],
       MAX([ActivatedAt])                                         AS [LastActivationAt],
       MAX(CASE WHEN [Status] = 2 THEN [DeactivatedAt] END)       AS [LastRollbackAt]
FROM [dbo].[AgentOutcomeLearningRolloutToggles]
WHERE [WorkspaceId] = @WorkspaceId;
