MERGE [dbo].[FeedbackWebhookEvents] AS T
    USING (VALUES (@Id, @EventId, @WorkspaceId, @Source, @EventType, @Severity, @Summary, @OccurredAt, @ReceivedAt,
    @PayloadJson, @TaskId, @RelatedTaskId, @RelatedTaskExecutionId, @ExternalReference, @ExternalUrl,
    @AgentName, @Reporter, @ReporterEmail)) AS S([Id], [EventId], [WorkspaceId], [Source], [EventType],
    [Severity], [Summary], [OccurredAt], [ReceivedAt],
    [PayloadJson], [TaskId], [RelatedTaskId],
    [RelatedTaskExecutionId], [ExternalReference],
    [ExternalUrl], [AgentName], [Reporter], [ReporterEmail])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[EventId] = S.[EventId],
    T.[WorkspaceId] = S.[WorkspaceId],
    T.[Source] = S.[Source],
    T.[EventType] = S.[EventType],
    T.[Severity] = S.[Severity],
    T.[Summary] = S.[Summary],
    T.[OccurredAt] = S.[OccurredAt],
    T.[ReceivedAt] = S.[ReceivedAt],
    T.[PayloadJson] = S.[PayloadJson],
    T.[TaskId] = S.[TaskId],
    T.[RelatedTaskId] = S.[RelatedTaskId],
    T.[RelatedTaskExecutionId] = S.[RelatedTaskExecutionId],
    T.[ExternalReference] = S.[ExternalReference],
    T.[ExternalUrl] = S.[ExternalUrl],
    T.[AgentName] = S.[AgentName],
    T.[Reporter] = S.[Reporter],
    T.[ReporterEmail] = S.[ReporterEmail]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[EventId],
[WorkspaceId],
[Source],
[EventType],
[Severity],
[Summary],
[OccurredAt],
[ReceivedAt],
[PayloadJson],
[TaskId],
[RelatedTaskId],
[RelatedTaskExecutionId],
[ExternalReference],
[ExternalUrl],
[AgentName],
[Reporter],
[ReporterEmail])
VALUES (S.[Id], S.[EventId], S.[WorkspaceId], S.[Source], S.[EventType], S.[Severity], S.[Summary], S.[OccurredAt], S.[ReceivedAt], S.[PayloadJson], S.[TaskId], S.[RelatedTaskId], S.[RelatedTaskExecutionId], S.[ExternalReference], S.[ExternalUrl], S.[AgentName], S.[Reporter], S.[ReporterEmail]);
