MERGE [dbo].[KnowledgeAdaptationArtifacts] AS Target
    USING (SELECT @Id AS Id, @WorkspaceId AS WorkspaceId) AS Source
    ON Target.[Id] = Source.[Id] AND Target.[WorkspaceId] = Source.[WorkspaceId]
    WHEN MATCHED THEN
UPDATE
    SET [ClassificationTag] = @ClassificationTag,
    [PrimarySource] = @PrimarySource,
    [Sensitivity] = @Sensitivity,
    [RedactionLevel] = @RedactionLevel,
    [Title] = @Title,
    [Summary] = @Summary,
    [MetadataJson] = @MetadataJson,
    [SupportingTelemetryIdsJson] = @SupportingTelemetryIdsJson,
    [ContributingWorkspacesJson] = @ContributingWorkspacesJson,
    [Confidence] = @Confidence,
    [SupportCount] = @SupportCount,
    [CreatedAtUtc] = @CreatedAtUtc,
    [LastEvaluatedAtUtc] = @LastEvaluatedAtUtc
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[WorkspaceId],
[ClassificationTag],
[PrimarySource],
[Sensitivity],
[RedactionLevel],
[Title],
[Summary],
[MetadataJson],
[SupportingTelemetryIdsJson],
[ContributingWorkspacesJson],
[Confidence],
[SupportCount],
[CreatedAtUtc],
[LastEvaluatedAtUtc])
VALUES (@Id, @WorkspaceId, @ClassificationTag, @PrimarySource, @Sensitivity, @RedactionLevel, @Title, @Summary, @MetadataJson, @SupportingTelemetryIdsJson, @ContributingWorkspacesJson, @Confidence, @SupportCount, @CreatedAtUtc, @LastEvaluatedAtUtc);

SELECT *
FROM [dbo].[KnowledgeAdaptationArtifacts]
WHERE [Id] = @Id AND [WorkspaceId] = @WorkspaceId;
