MERGE [dbo].[ModelRetrainingRolloutStates] AS T
    USING (VALUES (@WorkspaceId, @IsDeferred, @DeferUntilUtc, @DeferReason, @HasRollbackSignal, @RollbackReason, @Id)) AS S(
    [WorkspaceId],
    [IsDeferred],
    [DeferUntilUtc],
    [DeferReason],
    [HasRollbackSignal],
    [RollbackReason],
    [Id])
    ON T.[WorkspaceId] = S.[WorkspaceId]
    WHEN MATCHED THEN
UPDATE
    SET [IsDeferred] = S.[IsDeferred],
    [DeferUntilUtc] = S.[DeferUntilUtc],
    [DeferReason] = S.[DeferReason],
    [HasRollbackSignal] = S.[HasRollbackSignal],
    [RollbackReason] = S.[RollbackReason],
    [UpdatedAtUtc] = SYSUTCDATETIME()
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[WorkspaceId],
[IsDeferred],
[DeferUntilUtc],
[DeferReason],
[HasRollbackSignal],
[RollbackReason])
VALUES (S.[Id], S.[WorkspaceId], S.[IsDeferred], S.[DeferUntilUtc], S.[DeferReason], S.[HasRollbackSignal], S.[RollbackReason]);

SELECT TOP 1 [Id],
             [WorkspaceId],
             [IsDeferred],
             [DeferUntilUtc],
             [DeferReason],
             [HasRollbackSignal],
             [RollbackReason],
             [UpdatedAtUtc]
FROM [dbo].[ModelRetrainingRolloutStates]
WHERE [WorkspaceId] = @WorkspaceId;
