MERGE [dbo].[RefactorRuleUsages] AS T
    USING (VALUES (@RuleId, @WorkspaceId, @Included, @Triggered)) AS S([RuleId], [WorkspaceId], [Included], [Triggered])
    ON T.[RuleId] = S.[RuleId] AND T.[WorkspaceId] = S.[WorkspaceId]
    WHEN MATCHED THEN
UPDATE
    SET T.[Included] = S.[Included],
    T.[Triggered] = S.[Triggered]
    WHEN NOT MATCHED THEN
INSERT
(
[RuleId],
[WorkspaceId],
[Included],
[Triggered])
VALUES (S.[RuleId], S.[WorkspaceId], S.[Included], S.[Triggered]);
