MERGE [dbo].[ReviewerAvailabilities] AS T
    USING (VALUES (@Id, @ReviewerId, @DayOfWeek, @StartTime, @EndTime)) AS S([Id], [ReviewerId], [DayOfWeek], [StartTime], [EndTime])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[ReviewerId] = S.[ReviewerId],
    T.[DayOfWeek] = S.[DayOfWeek],
    T.[StartTime] = S.[StartTime],
    T.[EndTime] = S.[EndTime]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[ReviewerId],
[DayOfWeek],
[StartTime],
[EndTime])
VALUES (S.[Id], S.[ReviewerId], S.[DayOfWeek], S.[StartTime], S.[EndTime]);
