MERGE [dbo].[SharedContextEntries] AS T
    USING (VALUES (@TaskId, @Scope, @Value, @Version)) AS S([TaskId], [Scope], [Value], [Version])
    ON T.[TaskId] = S.[TaskId] AND T.[Scope] = S.[Scope]
    WHEN MATCHED THEN
UPDATE
    SET T.[Value] = S.[Value],
    T.[Version] = S.[Version]
    WHEN NOT MATCHED THEN
INSERT
(
[TaskId],
[Scope],
[Value],
[Version])
VALUES (S.[TaskId], S.[Scope], S.[Value], S.[Version]);
