MERGE [dbo].[TenantBillings] AS T
    USING (VALUES (@TenantId, @PaymentProviderCustomerId, @PaymentProviderSubscriptionId, @Plan, @Status, @MaxUsers,
    @TokenQuota, @DailyCostLimitUsd, @CostGuardrailBufferPercentage, @LastUsageReminderSentUtc, @LastOutOfTokensReminderSentUtc)) AS S([TenantId],
    [PaymentProviderCustomerId],
    [PaymentProviderSubscriptionId],
    [Plan], [Status], [MaxUsers],
    [TokenQuota],
    [DailyCostLimitUsd],
    [CostGuardrailBufferPercentage],
    [LastUsageReminderSentUtc],
    [LastOutOfTokensReminderSentUtc])
    ON T.[TenantId] = S.[TenantId]
    WHEN MATCHED THEN
UPDATE
    SET T.[PaymentProviderCustomerId] = S.[PaymentProviderCustomerId],
    T.[PaymentProviderSubscriptionId] = S.[PaymentProviderSubscriptionId],
    T.[Plan] = S.[Plan],
    T.[Status] = S.[Status],
    T.[MaxUsers] = S.[MaxUsers],
    T.[TokenQuota] = S.[TokenQuota],
    T.[DailyCostLimitUsd] = S.[DailyCostLimitUsd],
    T.[CostGuardrailBufferPercentage] = S.[CostGuardrailBufferPercentage],
    T.[LastUsageReminderSentUtc] = S.[LastUsageReminderSentUtc],
    T.[LastOutOfTokensReminderSentUtc] = S.[LastOutOfTokensReminderSentUtc]
    WHEN NOT MATCHED THEN
INSERT
(
[TenantId],
[PaymentProviderCustomerId],
[PaymentProviderSubscriptionId],
[Plan],
[Status],
[MaxUsers],
[TokenQuota],
[DailyCostLimitUsd],
[CostGuardrailBufferPercentage],
[LastUsageReminderSentUtc],
[LastOutOfTokensReminderSentUtc])
VALUES (S.[TenantId], S.[PaymentProviderCustomerId], S.[PaymentProviderSubscriptionId], S.[Plan], S.[Status], S.[MaxUsers], S.[TokenQuota], S.[DailyCostLimitUsd], S.[CostGuardrailBufferPercentage], S.[LastUsageReminderSentUtc], S.[LastOutOfTokensReminderSentUtc]);
