MERGE [dbo].[WorkspaceSettings] AS T
    USING (VALUES (@WorkspaceId, @Key, @Value, @Id, @IsSecret))
        AS S([WorkspaceId], [Key], [Value], [Id], [IsSecret])
    ON T.[WorkspaceId] = S.[WorkspaceId] AND T.[Key] = S.[Key]
    WHEN MATCHED THEN
UPDATE
    SET T.[Value] = S.[Value],
        T.[IsSecret] = S.[IsSecret]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[WorkspaceId],
[Key],
[Value],
[IsSecret])
VALUES (S.[Id], S.[WorkspaceId], S.[Key], S.[Value], S.[IsSecret]);
