MERGE [dbo].[AgentFeedbacks] AS T
    USING (VALUES (@Id, @TaskId, @AgentName, @IsHelpful, @Comment, @SubmittedAt, @Source, @SuggestedAgent,
    @Category)) AS S([Id], [TaskId], [AgentName], [IsHelpful], [Comment], [SubmittedAt], [Source],
    [SuggestedAgent], [Category])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[TaskId] = S.[TaskId],
    T.[AgentName] = S.[AgentName],
    T.[IsHelpful] = S.[IsHelpful],
    T.[Comment] = S.[Comment],
    T.[SubmittedAt] = S.[SubmittedAt],
    T.[Source] = S.[Source],
    T.[SuggestedAgent] = S.[SuggestedAgent],
    T.[Category] = S.[Category]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[TaskId],
[AgentName],
[IsHelpful],
[Comment],
[SubmittedAt],
[Source],
[SuggestedAgent],
[Category])
VALUES (S.[Id], S.[TaskId], S.[AgentName], S.[IsHelpful], S.[Comment], S.[SubmittedAt], S.[Source], S.[SuggestedAgent], S.[Category]);
