MERGE [dbo].[AgentOutcomeLearningProposals] AS Target
    USING (VALUES (@Id,
    @WorkspaceId,
    @AgentId,
    @DecisionKey,
    @Action,
    @Summary,
    @Rationale,
    @Confidence,
    @ScoreDelta,
    @SupportingSignalsJson,
    @MetadataJson,
    @GeneratedAt,
    @Status,
    @StatusUpdatedAt,
    @StatusChangedByUserId,
    @StatusReason,
    @ExpiresAt))
    AS Source (
    Id,
    WorkspaceId,
    AgentId,
    DecisionKey,
    Action,
    Summary,
    Rationale,
    Confidence,
    ScoreDelta,
    SupportingSignalsJson,
    MetadataJson,
    GeneratedAt,
    Status,
    StatusUpdatedAt,
    StatusChangedByUserId,
    StatusReason,
    ExpiresAt)
    ON Target.[WorkspaceId] = Source.WorkspaceId
    AND Target.[AgentId] = Source.AgentId
    AND Target.[DecisionKey] = Source.DecisionKey
    AND Target.[Action] = Source.Action
    AND Target.[Status] = Source.Status
    WHEN MATCHED THEN
UPDATE
    SET [Summary] = Source.Summary,
    [Rationale] = Source.Rationale,
    [Confidence] = Source.Confidence,
    [ScoreDelta] = Source.ScoreDelta,
    [SupportingSignalsJson] = Source.SupportingSignalsJson,
    [MetadataJson] = Source.MetadataJson,
    [GeneratedAt] = Source.GeneratedAt,
    [StatusUpdatedAt] = Source.StatusUpdatedAt,
    [StatusChangedByUserId] = Source.StatusChangedByUserId,
    [StatusReason] = Source.StatusReason,
    [ExpiresAt] = Source.ExpiresAt,
    [UpdatedAt] = SYSUTCDATETIME()
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[WorkspaceId],
[AgentId],
[DecisionKey],
[Action],
[Summary],
[Rationale],
[Confidence],
[ScoreDelta],
[SupportingSignalsJson],
[MetadataJson],
[GeneratedAt],
[Status],
[StatusUpdatedAt],
[StatusChangedByUserId],
[StatusReason],
[ExpiresAt],
[CreatedAt],
[UpdatedAt])
VALUES (Source.Id, Source.WorkspaceId, Source.AgentId, Source.DecisionKey, Source.Action, Source.Summary, Source.Rationale, Source.Confidence, Source.ScoreDelta, Source.SupportingSignalsJson, Source.MetadataJson, Source.GeneratedAt, Source.Status, Source.StatusUpdatedAt, Source.StatusChangedByUserId, Source.StatusReason, Source.ExpiresAt, SYSUTCDATETIME(), SYSUTCDATETIME())
    OUTPUT inserted.*;
