MERGE [dbo].[AgentResults] AS T
    USING (VALUES (@Id, @TaskId, @AgentName, @Success, @Output, @ErrorMessage, @CreatedAt)) AS S([Id], [TaskId],
    [AgentName], [Success],
    [Output], [ErrorMessage],
    [CreatedAt])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[TaskId] = S.[TaskId],
    T.[AgentName] = S.[AgentName],
    T.[Success] = S.[Success],
    T.[Output] = S.[Output],
    T.[ErrorMessage] = S.[ErrorMessage],
    T.[CreatedAt] = S.[CreatedAt]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[TaskId],
[AgentName],
[Success],
[Output],
[ErrorMessage],
[CreatedAt])
VALUES (S.[Id], S.[TaskId], S.[AgentName], S.[Success], S.[Output], S.[ErrorMessage], S.[CreatedAt]);
