MERGE [dbo].[ProcessDefinitions] AS T
    USING (VALUES (@WorkspaceId, @Version, @CreatedAt, @StepsJson, @RequiredMetadataJson)) AS S([WorkspaceId], [Version],
    [CreatedAt], [StepsJson],
    [RequiredMetadataJson])
    ON T.[WorkspaceId] = S.[WorkspaceId] AND T.[Version] = S.[Version]
    WHEN MATCHED THEN
UPDATE
    SET T.[CreatedAt] = S.[CreatedAt],
    T.[StepsJson] = S.[StepsJson],
    T.[RequiredMetadataJson] = S.[RequiredMetadataJson]
    WHEN NOT MATCHED THEN
INSERT
(
[WorkspaceId],
[Version],
[CreatedAt],
[StepsJson],
[RequiredMetadataJson])
VALUES (S.[WorkspaceId], S.[Version], S.[CreatedAt], S.[StepsJson], S.[RequiredMetadataJson]);
