MERGE [dbo].[ReviewSettings] AS T
    USING (VALUES (@Id, @DefaultReviewSlaMinutes, @DefaultConfidenceThreshold, @MaxAutoRetryOnRejection,
    @ReviewerAssignmentFallbackMinutes)) AS S([Id], [DefaultReviewSlaMinutes], [DefaultConfidenceThreshold],
    [MaxAutoRetryOnRejection], [ReviewerAssignmentFallbackMinutes])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[DefaultReviewSlaMinutes] = S.[DefaultReviewSlaMinutes],
    T.[DefaultConfidenceThreshold] = S.[DefaultConfidenceThreshold],
    T.[MaxAutoRetryOnRejection] = S.[MaxAutoRetryOnRejection],
    T.[ReviewerAssignmentFallbackMinutes] = S.[ReviewerAssignmentFallbackMinutes]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[DefaultReviewSlaMinutes],
[DefaultConfidenceThreshold],
[MaxAutoRetryOnRejection],
[ReviewerAssignmentFallbackMinutes])
VALUES (S.[Id], S.[DefaultReviewSlaMinutes], S.[DefaultConfidenceThreshold], S.[MaxAutoRetryOnRejection], S.[ReviewerAssignmentFallbackMinutes]);
