MERGE [dbo].[ReviewerRotationStates] AS T
    USING (VALUES (@WorkspaceId, @TaskType, @LastIndex)) AS S([WorkspaceId], [TaskType], [LastIndex])
    ON T.[WorkspaceId] = S.[WorkspaceId] AND T.[TaskType] = S.[TaskType]
    WHEN MATCHED THEN
UPDATE
    SET T.[LastIndex] = S.[LastIndex]
    WHEN NOT MATCHED THEN
INSERT
(
[WorkspaceId],
[TaskType],
[LastIndex])
VALUES (S.[WorkspaceId], S.[TaskType], S.[LastIndex]);
