MERGE [dbo].[StatusTransitions] AS T
    USING (VALUES (@TaskExecutionId, @Status, @Timestamp, @Message)) AS S([TaskExecutionId], [Status], [Timestamp], [Message])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[TaskExecutionId] = S.[TaskExecutionId],
    T.[Status] = S.[Status],
    T.[Timestamp] = S.[Timestamp],
    T.[Message] = S.[Message]
    WHEN NOT MATCHED THEN
INSERT
(
[TaskExecutionId],
[Status],
[Timestamp],
[Message])
VALUES (S.[TaskExecutionId], S.[Status], S.[Timestamp], S.[Message]);
