MERGE [dbo].[StrategyFitness] AS T
    USING (VALUES (@Id, @TaskExecutionId, @StrategyId, @Success, @RetryCount, @FeedbackScore, @DiffSize, @DurationSeconds,
    @RecordedAt)) AS S([Id], [TaskExecutionId], [StrategyId], [Success], [RetryCount], [FeedbackScore],
    [DiffSize], [DurationSeconds], [RecordedAt])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[TaskExecutionId] = S.[TaskExecutionId],
    T.[StrategyId] = S.[StrategyId],
    T.[Success] = S.[Success],
    T.[RetryCount] = S.[RetryCount],
    T.[FeedbackScore] = S.[FeedbackScore],
    T.[DiffSize] = S.[DiffSize],
    T.[DurationSeconds] = S.[DurationSeconds],
    T.[RecordedAt] = S.[RecordedAt]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[TaskExecutionId],
[StrategyId],
[Success],
[RetryCount],
[FeedbackScore],
[DiffSize],
[DurationSeconds],
[RecordedAt])
VALUES (S.[Id], S.[TaskExecutionId], S.[StrategyId], S.[Success], S.[RetryCount], S.[FeedbackScore], S.[DiffSize], S.[DurationSeconds], S.[RecordedAt]);
