MERGE [dbo].[TaskExecutionAudits] AS T
    USING (VALUES (@Id, @TaskExecutionId, @Timestamp, @UpdatedBy, @ChangesJson)) AS S([Id], [TaskExecutionId], [Timestamp], [UpdatedBy], [ChangesJson])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[TaskExecutionId] = S.[TaskExecutionId],
    T.[Timestamp] = S.[Timestamp],
    T.[UpdatedBy] = S.[UpdatedBy],
    T.[ChangesJson] = S.[ChangesJson]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[TaskExecutionId],
[Timestamp],
[UpdatedBy],
[ChangesJson])
VALUES (S.[Id], S.[TaskExecutionId], S.[Timestamp], S.[UpdatedBy], S.[ChangesJson]);
