SELECT COUNT(1)
FROM [dbo].[TaskExecutions] te
WHERE te.[ConfidenceScore] IS NOT NULL
  AND te.[ConfidenceScore]
    < @Threshold
  AND te.[Status] IN (@PausedStatus
    , @AwaitingStatus);

SELECT te.[WorkKind], AVG(CAST(te.[ConfidenceScore] AS FLOAT)) AS [Avg]
FROM [dbo].[TaskExecutions] te
WHERE te.[ConfidenceScore] IS NOT NULL
GROUP BY te.[WorkKind];

SELECT tr.[Decision], COUNT(1) AS [Count]
FROM [dbo].[TaskExecutions] te
    INNER JOIN [dbo].[TaskReviews] tr
ON tr.[TaskExecutionId] = te.[Id]
WHERE te.[ConfidenceScore] IS NOT NULL
  AND te.[ConfidenceScore]
    < @Threshold
  AND tr.[Decision] IN (@ApprovedDecision
    , @RejectedDecision)
GROUP BY tr.[Decision];
